IF OBJECT_ID('P_EST_PROD_ENT_GRP_ECON_GRAVAR') IS NOT NULL
    BEGIN
	   DROP PROCEDURE P_EST_PROD_ENT_GRP_ECON_GRAVAR;
    END;
GO

--EXEC P_EST_PROD_ENT_GRP_ECON_GRAVAR 1,'2018-07-11','2018-07-11'
CREATE PROCEDURE P_EST_PROD_ENT_GRP_ECON_GRAVAR (@CD_EMP INT =1, 
											 @DT_INI DATE=null , 
											 @DT_FIM DATE=null,
											 @Reprocessar Tinyint =0)
AS
BEGIN
    SET NOCOUNT ON;
    SET DEADLOCK_PRIORITY 6; 


    if @DT_INI is null 
	   set @DT_INI=getdate()-7

    if @DT_FIM  is null 
	   set @DT_FIM  =getdate()

	 if @Reprocessar  =1 
	 begin

		DELETE FROM  EST_PROD_ENT_GRP_ECON;
		TRUNCATE TABLE EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT;

		SET @DT_INI='20160101'
	 end


							
    print 'Processando o periodo de ' + convert(varchar, @dt_ini) + ' a ' + convert(varchar, @dt_fim);

/******************************************************************************************************************/
    CREATE TABLE #RsProdEntrada
	   (CD_EMP    INT
	   , CD_PROD   INT
	   , DT_HR_CAD DATETIME
	   );

    CREATE TABLE #Proc_Prod_Ultima_Entrada
		  (CD_EMP        INT
		  , CD_FILIAL     INT
		  , CD_NF         INT
		  , CD_PROD       INT
		  , VLR_IT        MONEY
		  , VLR_ICMS_IT   MONEY
		  , VLR_DESC      MONEY
		  , ALIQ_ICMS     MONEY
		  , PERC_IVA      MONEY
		  , VLR_ICMS_SUBS MONEY
		  , VLR_PRC_CUSTO MONEY
		  , DS_PROD       VARCHAR(250)
		  , DT_HR_CAD     DATETIME
		  , DT_ENT        DATETIME
		  );

/******************************************************************************************************************/

    DELETE FROM EST_PROD_ENT_GRP_ECON     WHERE    DT_HR_CAD_ENTRADA IS NULL;     
    DELETE FROM EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT     WHERE    DT_HR_CAD_ENTRADA IS NULL; 
     
/******************************************************************************************************************/
    --Correcao das datas/hora  que estao nullas

    update EST_NF_ENT
    SET
	   EST_NF_ENT.DT_HR_CAD=(EST_NF_ENT.DT_ENT + EST_NF_ENT.HR_ENT)
	   WHERE 
		  EST_NF_ENT.CD_EMP = @CD_EMP
		  AND EST_NF_ENT.DT_ENT BETWEEN @DT_INI AND @DT_FIM
		  AND EST_NF_ENT.DT_HR_CAD IS NULL;
		   
/******************************************************************************************************************/
    INSERT INTO #RsProdEntrada
    SELECT
	   EST_NF_ENT.CD_EMP
	   , EST_NF_ENT_IT.CD_PROD
	   , MAX(EST_NF_ENT.DT_HR_CAD) AS DT_HR_CAD 		   
    FROM
	   EST_NF_ENT
	   INNER JOIN EST_NF_ENT_IT
	   ON EST_NF_ENT.CD_EMP = EST_NF_ENT_IT.CD_EMP
		  AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
		  AND EST_NF_ENT.CD_NF = EST_NF_ENT_IT.CD_NF
		  AND EST_NF_ENT.DT_ENT = EST_NF_ENT_IT.DT_ENT
	   INNER JOIN GLB_MOV_OP  O 
	   ON EST_NF_ENT.CD_NT_MOV = O.CD_MOV_OP
    WHERE EST_NF_ENT.CD_EMP = @CD_EMP
	   AND EST_NF_ENT.DT_ENT BETWEEN @DT_INI AND @DT_FIM
	   AND O.TP_MOV=0
	   AND O.TP_MOV_OP_TRANSA=0
    GROUP BY
	   EST_NF_ENT.CD_EMP
	   , EST_NF_ENT_IT.CD_PROD;

	   
/******************************************************************************************************************/
 
    INSERT INTO #Proc_Prod_Ultima_Entrada
    SELECT
	   EST_NF_ENT_IT.CD_EMP
	   , EST_NF_ENT_IT.CD_FILIAL
	   , MAX(EST_NF_ENT_IT.CD_NF)
	   , EST_NF_ENT_IT.CD_PROD
	   , avg(EST_NF_ENT_IT.VLR_IT)
	   , avg(EST_NF_ENT_IT.VLR_ICMS_IT)
	   , avg(EST_NF_ENT_IT.VLR_DESC)
	   , avg(EST_NF_ENT_IT.ALIQ_ICMS)
	   , avg(EST_NF_ENT_IT.PERC_IVA)
	   , avg(EST_NF_ENT_IT.VLR_ICMS_SUBS)
	   , avg(EST_NF_ENT_IT.VLR_PRC_CUSTO)
	   , EST_PROD.DS_PROD
	   , p.DT_HR_CAD
	   , EST_NF_ENT.DT_ENT
    FROM
	   EST_NF_ENT_IT
	   INNER JOIN EST_NF_ENT
	   ON EST_NF_ENT.CD_EMP = EST_NF_ENT_IT.CD_EMP
			AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
			AND EST_NF_ENT.CD_NF = EST_NF_ENT_IT.CD_NF
			AND EST_NF_ENT.DT_ENT = EST_NF_ENT_IT.DT_ENT
	   INNER JOIN #RsProdEntrada p
	   ON EST_NF_ENT.CD_EMP = p.CD_EMP
		  AND EST_NF_ENT_IT.CD_PROD = p.CD_PROD
		  AND EST_NF_ENT.DT_HR_CAD = p.DT_HR_CAD
	   INNER JOIN EST_PROD
	   ON EST_NF_ENT_IT.CD_EMP = EST_PROD.CD_EMP
		  AND EST_NF_ENT_IT.CD_PROD = EST_PROD.CD_PROD
    WHERE EST_NF_ENT.CD_EMP = @CD_EMP
	   AND EST_NF_ENT.DT_ENT BETWEEN @DT_INI AND @DT_FIM
	GROUP BY
	    EST_NF_ENT_IT.CD_EMP
	   , EST_NF_ENT_IT.CD_FILIAL
	   , EST_NF_ENT_IT.CD_PROD
	   , EST_PROD.DS_PROD
	   , p.DT_HR_CAD
	   , EST_NF_ENT.DT_ENT;   
	    --select * from #Proc_Prod_Ultima_Entrada  where cd_prod = 47588
/******************************************************************************************************************/
    DELETE VINC
    FROM EST_PROD_ENT_GRP_ECON VINC
	   INNER JOIN #Proc_Prod_Ultima_Entrada CTE
	   ON VINC.CD_EMP = CTE.CD_EMP
		  AND VINC.CD_PROD = CTE.CD_PROD
		  AND VINC.DT_HR_CAD_ENTRADA < CTE.DT_HR_CAD;

/******************************************************************************************************************/
    DELETE IT
    FROM EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT IT
	   INNER JOIN #Proc_Prod_Ultima_Entrada CTE
	   ON IT.CD_EMP = CTE.CD_EMP
		  AND IT.CD_PROD = CTE.CD_PROD
		  AND IT.DT_HR_CAD_ENTRADA < CTE.DT_HR_CAD;

/******************************************************************************************************************/
   
    INSERT INTO EST_PROD_ENT_GRP_ECON(
	   CD_EMP
	   , CD_PROD
	   , VLR_IT
	   , VLR_ICMS_IT
	   , VLR_DESC_IT
	   , PERC_ICMS
	   , PERC_IVA
	   , VLR_ICMS_SUBST_IT
	   , VLR_CUSTO_IT
	   , ORIG_LANC
	   , DT_HR_CAD_ENTRADA
	   , DT_CAD
	   , DT_ENTRADA)
    SELECT  
	     CTE.CD_EMP
	   , CTE.CD_PROD
	   , AVG(CTE.VLR_IT)
	   , AVG(CTE.VLR_ICMS_IT)
	   , AVG(CTE.VLR_DESC)
	   , AVG(CTE.VLR_DESC)
	   , AVG(CTE.PERC_IVA)
	   , AVG(CTE.VLR_ICMS_SUBS)
	   , AVG(CTE.VLR_PRC_CUSTO)
	   , 0
	   , MAX(DT_HR_CAD) DT_HR_CAD
	   , GETDATE()
	   , MAX(CTE.DT_ENT) DT_ENT
    FROM
	   #Proc_Prod_Ultima_Entrada CTE
	   LEFT JOIN EST_PROD_ENT_GRP_ECON VINC
	   ON VINC.CD_EMP = CTE.CD_EMP
		  AND VINC.CD_PROD = CTE.CD_PROD
    WHERE 
		VINC.CD_EMP IS NULL
	GROUP BY
		 CTE.CD_EMP
	   , CTE.CD_PROD ;
     
/******************************************************************************************************************/
    INSERT INTO EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT(
	   CD_EMP
	   , CD_FILIAL
	   , CD_NF
	   , CD_PROD
	   , DT_HR_CAD_ENTRADA)
    SELECT
	   CTE.CD_EMP
	   , CTE.CD_FILIAL
	   , CTE.CD_NF
	   , CTE.CD_PROD
	   , CTE.DT_HR_CAD
    FROM
	   #Proc_Prod_Ultima_Entrada CTE
	   LEFT JOIN EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT IT
	   ON IT.CD_EMP = CTE.CD_EMP
		  AND IT.CD_FILIAL = CTE.CD_FILIAL
		  AND IT.CD_NF = CTE.CD_NF
		  AND IT.CD_PROD = CTE.CD_PROD
    WHERE IT.CD_EMP IS NULL;

    
--select  * From EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT where cd_prod = 47588

    DELETE FROM EST_PROD_ENT_GRP_ECON
    WHERE
    DT_HR_CAD_ENTRADA IS NULL; 

    
    DELETE FROM EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT
    WHERE
    DT_HR_CAD_ENTRADA IS NULL; 

    
--select  * From EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT where cd_prod = 47588
/******************************************************************************************************************/
--Remove registros duplicados
 

 ;WHILE EXISTS
(
	SELECT
		  a.cd_emp, a.cd_prod, b.cd_grp_econ, a.dt_hr_cad_entrada
		 , COUNT(*) Qtde
	FROM
		EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT a
		JOIN prc_grp_econ_prc_filial b ON a.cd_emp = b.cd_emp
										  AND a.cd_filial = b.cd_filial
	GROUP BY
			a.cd_emp, a.cd_prod, b.cd_grp_econ, a.dt_hr_cad_entrada
	HAVING COUNT(*) > 1
)
	BEGIN
		DELETE    FROM C
		 FROM 
				(
					SELECT
						  a.cd_emp, a.cd_prod, b.cd_grp_econ, a.dt_hr_cad_entrada
						 , COUNT(*) Qtde
					FROM
						EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT a
						JOIN prc_grp_econ_prc_filial b ON a.cd_emp = b.cd_emp
														  AND a.cd_filial = b.cd_filial
					GROUP BY
							a.cd_emp, a.cd_prod, b.cd_grp_econ, a.dt_hr_cad_entrada
					HAVING COUNT(*) > 1
				) a
				JOIN
				(
					SELECT
						  a.cd_emp, a.cd_prod, b.cd_grp_econ, a.dt_hr_cad_entrada
						 , MIN(A.CD_NF) CD_NF
					FROM
						EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT a
						JOIN prc_grp_econ_prc_filial b ON a.cd_emp = b.cd_emp
														  AND a.cd_filial = b.cd_filial 
					GROUP BY
						a.cd_emp, a.cd_prod, b.cd_grp_econ, a.dt_hr_cad_entrada
				) b ON a.cd_grp_econ = b.cd_grp_econ
					   AND a.cd_emp = b.cd_emp
					   AND a.cd_prod = b.cd_prod
				JOIN EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT c ON b.cd_emp = c.cd_emp
															  AND b.cd_prod = c.cd_prod
															  AND b.CD_NF = c.CD_NF;
	END;


;WHILE EXISTS
(
	SELECT
		   b.cd_emp
		 , b.cd_grp_econ
		 , a.cd_prod
		 , COUNT(*) Qtde
	FROM
		EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT a
		JOIN prc_grp_econ_prc_filial b ON a.cd_emp = b.cd_emp
										  AND a.cd_filial = b.cd_filial
	GROUP BY
			 b.cd_grp_econ
		   , b.cd_emp
		   , a.cd_prod
	HAVING COUNT(*) > 1
)
	BEGIN
		DELETE    FROM C
		FROM 
				(
					SELECT
						   b.cd_emp
						 , b.cd_grp_econ
						 , a.cd_prod
						 , COUNT(*) Qtde
					FROM
						EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT a
						JOIN prc_grp_econ_prc_filial b ON a.cd_emp = b.cd_emp
														  AND a.cd_filial = b.cd_filial
					GROUP BY
							 b.cd_grp_econ
						   , b.cd_emp
						   , a.cd_prod
					HAVING COUNT(*) > 1
				) a
				JOIN
				(
					SELECT
						   b.cd_emp
						 , b.cd_grp_econ
						 , a.cd_prod
						 , MIN(DT_HR_CAD_ENTRADA) DT_HR_CAD_ENTRADA
					FROM
						EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT a
						JOIN prc_grp_econ_prc_filial b ON a.cd_emp = b.cd_emp
														  AND a.cd_filial = b.cd_filial 
					GROUP BY
							 b.cd_grp_econ
						   , b.cd_emp
						   , a.cd_prod
				) b ON a.cd_grp_econ = b.cd_grp_econ
					   AND a.cd_emp = b.cd_emp
					   AND a.cd_prod = b.cd_prod
				JOIN EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT c ON b.cd_emp = c.cd_emp
															  AND b.cd_prod = c.cd_prod
															  AND b.DT_HR_CAD_ENTRADA = c.DT_HR_CAD_ENTRADA;
	END;



    TRUNCATE TABLE #Proc_Prod_Ultima_Entrada;
    PRINT 'P_EST_PROD_ENT_GRP_ECON_GRAVAR CONCLUIDA '+CONVERT(VARCHAR, GETDATE(), 108);
 
/******************************************************************************************************************/
END;